/**
 * Copyright (C) 2012 - 2014, BMW AG
 *
 * This file is part of GENIVI Project AudioManager.
 *
 * Contributions are licensed to the GENIVI Alliance under one or more
 * Contribution License Agreements.
 *
 * \copyright
 * This Source Code Form is subject to the terms of the
 * Mozilla Public License, v. 2.0. If a  copy of the MPL was not distributed with
 * this file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *
 * \author Christian Linke, christian.linke@bmw.de BMW 2011 - 2014
 *
 * \file
 * For further information see http://projects.genivi.org/audio-manager
 *
 * THIS CODE HAS BEEN GENERATED BY ENTERPRISE ARCHITECT GENIVI MODEL.
 * PLEASE CHANGE ONLY IN ENTERPRISE ARCHITECT AND GENERATE AGAIN.
 */
#if !defined(EA_69597D9E_B0A3_4c6d_BBB6_E7F436B8B799__INCLUDED_)
#define EA_69597D9E_B0A3_4c6d_BBB6_E7F436B8B799__INCLUDED_

#include <vector>
#include <string>
#include "audiomanagertypes.h"
namespace am {
class CAmSocketHandler;
}

#include "audiomanagertypes.h"

#define ControlVersion "4.0"
namespace am {

/**
 * This interface gives access to all important functions of the audiomanager that
 * are used by the AudioManagerController to control the system.
 * There are two rules that have to be kept in mind when implementing against this
 * interface:\n
 * \warning
 * 1. CALLS TO THIS INTERFACE ARE NOT THREAD SAFE !!!! \n
 * 2. YOU MAY NOT CALL THE CALLING INTERFACE DURING AN SYNCHRONOUS OR ASYNCHRONOUS
 * CALL THAT EXPECTS A RETURN VALUE.\n
 * \details
 * Violation these rules may lead to unexpected behavior! Nevertheless you can
 * implement thread safe by using the deferred-call pattern described on the wiki
 * which also helps to implement calls that are forbidden.\n
 * For more information, please check CAmSerializer
 */
class IAmControlReceive
{

public:
  IAmControlReceive() {

  }

  virtual ~IAmControlReceive() {

  }

  /**
   * This function returns the version of the interface
   */
  virtual void getInterfaceVersion(std::string& version) const =0;
  /**
   * calculates a route from source to sink.
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual am_Error_e getRoute(const bool onlyfree, const am_sourceID_t sourceID, const am_sinkID_t sinkID, std::vector<am_Route_s>& returnList) =0;
  /**
   * With this function, elementary connects can be triggered by the controller.
   * @return E_OK on success, E_UNKNOWN on error, E_WRONG_FORMAT of
   * connectionFormats do not match, E_NO_CHANGE if the desired connection is
   * already build up
   */
  virtual am_Error_e connect(am_Handle_s& handle, am_connectionID_t& connectionID, const am_CustomConnectionFormat_t format, const am_sourceID_t sourceID, const am_sinkID_t sinkID) =0;
  /**
   * is used to disconnect a connection
   * @return E_OK on success, E_UNKNOWN on error, E_NON_EXISTENT if connection was
   * not found, E_NO_CHANGE if no change is neccessary
   */
  virtual am_Error_e disconnect(am_Handle_s& handle, const am_connectionID_t connectionID) =0;
  /**
   * triggers a cross fade.
   * @return E_OK on success, E_UNKNOWN on error E_NO_CHANGE if no change is
   * neccessary
   */
  virtual am_Error_e crossfade(am_Handle_s& handle, const am_HotSink_e hotSource, const am_crossfaderID_t crossfaderID, const am_CustomRampType_t rampType, const am_time_t rampTime) =0;
  /**
   * with this method, all actions that have a handle assigned can be stopped.
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual am_Error_e abortAction(const am_Handle_s handle) =0;
  /**
   * this method sets a source state for a source. This function will trigger the
   * callback cbAckSetSourceState
   * @return E_OK on success, E_NO_CHANGE if the desired value is already correct,
   * E_UNKNOWN on error, E_NO_CHANGE if no change is neccessary
   */
  virtual am_Error_e setSourceState(am_Handle_s& handle, const am_sourceID_t sourceID, const am_SourceState_e state) =0;
  /**
   * with this function, setting of sinks volumes is done. The behavior of the
   * volume set is depended on the given ramp and time information.
   * This function is not only used to ramp volume, but also to mute and direct set
   * the level. Exact behavior is depended on the selected mute ramps.
   * @return E_OK on success, E_NO_CHANGE if the volume is already on the desired
   * value, E_OUT_OF_RANGE is the volume is out of range, E_UNKNOWN on every other
   * error.
   */
  virtual am_Error_e setSinkVolume(am_Handle_s& handle, const am_sinkID_t sinkID, const am_volume_t volume, const am_CustomRampType_t ramp, const am_time_t time) =0;
  /**
   * with this function, setting of source volumes is done. The behavior of the
   * volume set is depended on the given ramp and time information.
   * This function is not only used to ramp volume, but also to mute and direct set
   * the level. Exact behavior is depended on the selected mute ramps.
   * @return E_OK on success, E_NO_CHANGE if the volume is already on the desired
   * value, E_OUT_OF_RANGE is the volume is out of range, E_UNKNOWN on every other
   * error.
   */
  virtual am_Error_e setSourceVolume(am_Handle_s& handle, const am_sourceID_t sourceID, const am_volume_t volume, const am_CustomRampType_t rampType, const am_time_t time) =0;
  /**
   * is used to set several sinkSoundProperties at a time
   * @return E_OK on success, E_UNKNOWN on error, E_OUT_OF_RANGE  if property is out
   * of range, E_NO_CHANGE if no change is neccessary
   */
  virtual am_Error_e setSinkSoundProperties(am_Handle_s& handle, const am_sinkID_t sinkID, const std::vector<am_SoundProperty_s>& soundProperty) =0;
  /**
   * is used to set sinkSoundProperties
   * @return E_OK on success, E_UNKNOWN on error, E_OUT_OF_RANGE  if property is out
   * of range, E_NO_CHANGE if no change is neccessary
   */
  virtual am_Error_e setSinkSoundProperty(am_Handle_s& handle, const am_sinkID_t sinkID, const am_SoundProperty_s& soundProperty) =0;
  /**
   * is used to set several SourceSoundProperties at a time
   * @return E_OK on success, E_UNKNOWN on error, E_OUT_OF_RANGE  if property is out
   * of range. E_NO_CHANGE if no change is neccessary
   */
  virtual am_Error_e setSourceSoundProperties(am_Handle_s& handle, const am_sourceID_t sourceID, const std::vector<am_SoundProperty_s>& soundProperty) =0;
  /**
   * is used to set sourceSoundProperties
   * @return E_OK on success, E_UNKNOWN on error, E_OUT_OF_RANGE  if property is out
   * of range. E_NO_CHANGE if no change is neccessary
   */
  virtual am_Error_e setSourceSoundProperty(am_Handle_s& handle, const am_sourceID_t sourceID, const am_SoundProperty_s& soundProperty) =0;
  /**
   * sets the domain state of a domain
   * @return E_OK on success, E_UNKNOWN on error, E_NO_CHANGE if no change is
   * neccessary
   */
  virtual am_Error_e setDomainState(const am_domainID_t domainID, const am_DomainState_e domainState) =0;
  /**
   * enters a domain in the database, creates and ID
   * @return E_OK on success, E_ALREADY_EXISTENT if the ID or name is already in the
   * database, E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e enterDomainDB(const am_Domain_s& domainData, am_domainID_t& domainID) =0;
  /**
   * enters a mainconnection in the database, creates and ID
   * @return E_OK on success, E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e enterMainConnectionDB(const am_MainConnection_s& mainConnectionData, am_mainConnectionID_t& connectionID) =0;
  /**
   * enters a sink in the database.
   * The sinkID in am_Sink_s shall be 0 in case of a dynamic added source A sinkID
   * greater than 100 will be assigned. If a specific sinkID with a value <100 is
   * given, the given value will be used. This is for a static setup where the ID's
   * are predefined.
   * @return E_OK on success, E_ALREADY_EXISTENT if the ID or name is already in the
   * database, E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e enterSinkDB(const am_Sink_s& sinkData, am_sinkID_t& sinkID) =0;
  /**
   * enters a crossfader in the database.
   * The crossfaderID in am_Crossfader_s shall be 0 in case of a dynamic added
   * source A crossfaderID greater than 100 will be assigned. If a specific
   * crossfaderID with a value <100 is given, the given value will be used. This is
   * for a static setup where the ID's are predefined.
   * @return E_OK on success, E_ALREADY_EXISTENT if the ID or name is already in the
   * database, E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e enterCrossfaderDB(const am_Crossfader_s& crossfaderData, am_crossfaderID_t& crossfaderID) =0;
  /**
   * enters a gateway in the database.
   * The gatewayID in am_Gateway_s shall be 0 in case of a dynamic added source A
   * gatewayID greater than 100 will be assigned. If a specific gatewayID with a
   * value <100 is given, the given value will be used. This is for a static setup
   * where the ID's are predefined.
   * @return E_OK on success, E_ALREADY_EXISTENT if the ID or name is already in the
   * database, E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e enterGatewayDB(const am_Gateway_s& gatewayData, am_gatewayID_t& gatewayID) =0;
  /**
   * enters a converter in the database.
   * The converterID in am_Converter_s shall be 0 in case of a dynamic added source
   * A converterID greater than 100 will be assigned. If a specific gatewayID with a
   * value <100 is given, the given value will be used. This is for a static setup
   * where the ID's are predefined.
   * @return E_OK on success, E_ALREADY_EXISTENT if the ID or name is already in the
   * database, E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e enterConverterDB(const am_Converter_s& converterData, am_converterID_t& converterID) =0;
  /**
   * enters a source in the database.
   * The sourceID in am_Source_s shall be 0 in case of a dynamic added source A
   * sourceID greater than 100 will be assigned. If a specific sourceID with a value
   * <100 is given, the given value will be used. This is for a static setup where
   * the ID's are predefined.
   * @return E_OK on success, E_ALREADY_EXISTENT if the ID or name is already in the
   * database, E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e enterSourceDB(const am_Source_s& sourceData, am_sourceID_t& sourceID) =0;
  /**
   * Enters a sourceClass into the database.
   * @return E_OK on success, E_ALREADY_EXISTENT if the ID or name is already in the
   * database, E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e enterSinkClassDB(const am_SinkClass_s& sinkClass, am_sinkClass_t& sinkClassID) =0;
  /**
   * Enters a sourceClass into the database.
   * The sourceClassID in am_sourceClass_s shall be 0 in case of a dynamic added
   * source A sourceClassID greater than 100 will be assigned. If a specific
   * sourceClassID with a value <100 is given, the given value will be used. This is
   * for a static setup where the ID's are predefined.
   * @return E_OK on success, E_ALREADY_EXISTENT if the ID or name is already in the
   * database, E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e enterSourceClassDB(am_sourceClass_t& sourceClassID, const am_SourceClass_s& sourceClass) =0;
  /**
   * changes class information of a sinkclass.
   * The properties will overwrite the values of the sinkClassID given in the
   * sinkClass.
   * It is the duty of the controller to check if the property is valid. If it does
   * not exist, the daemon will not return an error.
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if
   * sinkClassID was not found.
   */
  virtual am_Error_e changeSinkClassInfoDB(const am_SinkClass_s& sinkClass) =0;
  /**
   * changes class information of a sourceClass.
   * The properties will overwrite the values of the sourceClassID given in the
   * sourceClass.
   * It is the duty of the controller to check if the property is valid. If it does
   * not exist, the daemon will not return an error.
   * @return E_OK on success, E_DATABASE_ERROR on error and E_NON_EXISTENT if the
   * ClassID does not exist.
   */
  virtual am_Error_e changeSourceClassInfoDB(const am_SourceClass_s& sourceClass) =0;
  /**
   * This function is used to enter the system Properties into the database.
   * All entries in the database will be erased before entering the new List. It
   * should only be called once at system startup.
   * @return E_OK on success,  E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e enterSystemPropertiesListDB(const std::vector<am_SystemProperty_s>& listSystemProperties) =0;
  /**
   * changes the mainConnectionState of MainConnection
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if
   * mainconnection
   */
  virtual am_Error_e changeMainConnectionRouteDB(const am_mainConnectionID_t mainconnectionID, const std::vector<am_connectionID_t>& listConnectionID) =0;
  /**
   * changes the mainConnectionState of MainConnection
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if
   * mainconnection
   */
  virtual am_Error_e changeMainConnectionStateDB(const am_mainConnectionID_t mainconnectionID, const am_ConnectionState_e connectionState) =0;
  /**
   * changes the sink volume of a sink
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if sink was
   * not found
   */
  virtual am_Error_e changeSinkMainVolumeDB(const am_mainVolume_t mainVolume, const am_sinkID_t sinkID) =0;
  /**
   * changes the availablility of a sink
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if sink was
   * not found
   */
  virtual am_Error_e changeSinkAvailabilityDB(const am_Availability_s& availability, const am_sinkID_t sinkID) =0;
  /**
   * changes the domainstate of a domain
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if domain
   * was not found
   */
  virtual am_Error_e changDomainStateDB(const am_DomainState_e domainState, const am_domainID_t domainID) =0;
  /**
   * changes the mute state of a sink
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if sink was
   * not found
   */
  virtual am_Error_e changeSinkMuteStateDB(const am_MuteState_e muteState, const am_sinkID_t sinkID) =0;
  /**
   * changes the mainsinksoundproperty of a sink
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if sink was
   * not found
   */
  virtual am_Error_e changeMainSinkSoundPropertyDB(const am_MainSoundProperty_s& soundProperty, const am_sinkID_t sinkID) =0;
  /**
   * changes the mainsourcesoundproperty of a sink
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if source
   * was not found
   */
  virtual am_Error_e changeMainSourceSoundPropertyDB(const am_MainSoundProperty_s& soundProperty, const am_sourceID_t sourceID) =0;
  /**
   * changes the availablility of a source
   * @return E_OK on success, E_DATABASE_ERROR  on error, E_NON_EXISTENT if source
   * was not found
   */
  virtual am_Error_e changeSourceAvailabilityDB(const am_Availability_s& availability, const am_sourceID_t sourceID) =0;
  /**
   * changes a systemProperty
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if property
   * was not found
   */
  virtual am_Error_e changeSystemPropertyDB(const am_SystemProperty_s& property) =0;
  /**
   * removes a mainconnection from the DB
   * @return E_OK on success, E_NON_EXISTENT if main connection was not found,
   * E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e removeMainConnectionDB(const am_mainConnectionID_t mainConnectionID) =0;
  /**
   * removes a sink from the DB
   * @return E_OK on success, E_NON_EXISTENT if sink was not found, E_DATABASE_ERROR
   * if the database had an error
   */
  virtual am_Error_e removeSinkDB(const am_sinkID_t sinkID) =0;
  /**
   * removes a source from the DB
   * @return E_OK on success, E_NON_EXISTENT if source was not found,
   * E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e removeSourceDB(const am_sourceID_t sourceID) =0;
  /**
   * removes a gateway from the DB
   * @return E_OK on success, E_NON_EXISTENT if gateway was not found,
   * E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e removeGatewayDB(const am_gatewayID_t gatewayID) =0;
  /**
   * removes a converter from the DB
   * @return E_OK on success, E_NON_EXISTENT if gateway was not found,
   * E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e removeConverterDB(const am_converterID_t converterID) =0;
  /**
   * removes a crossfader from the DB
   * @return E_OK on success, E_NON_EXISTENT if crossfader was not found,
   * E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e removeCrossfaderDB(const am_crossfaderID_t crossfaderID) =0;
  /**
   * removes a domain from the DB
   * @return E_OK on success, E_NON_EXISTENT if domain was not found,
   * E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e removeDomainDB(const am_domainID_t domainID) =0;
  /**
   * removes a domain from the DB
   * @return E_OK on success, E_NON_EXISTENT if domain was not found,
   * E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e removeSinkClassDB(const am_sinkClass_t sinkClassID) =0;
  /**
   * removes a domain from the DB
   * @return E_OK on success, E_NON_EXISTENT if domain was not found,
   * E_DATABASE_ERROR if the database had an error
   */
  virtual am_Error_e removeSourceClassDB(const am_sourceClass_t sourceClassID) =0;
  /**
   * returns the ClassInformation of a source
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if source
   * was not found
   */
  virtual am_Error_e getSourceClassInfoDB(const am_sourceID_t sourceID, am_SourceClass_s& classInfo) const =0;
  /**
   * returns the ClassInformation of a sink
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if sink was
   * not found
   */
  virtual am_Error_e getSinkClassInfoDB(const am_sinkID_t sinkID, am_SinkClass_s& sinkClass) const =0;
  /**
   * returns the sinkData of a sink
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if sink was
   * not found
   */
  virtual am_Error_e getSinkInfoDB(const am_sinkID_t sinkID, am_Sink_s& sinkData) const =0;
  /**
   * returns the sourcekData of a source
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if sink was
   * not found
   */
  virtual am_Error_e getSourceInfoDB(const am_sourceID_t sourceID, am_Source_s& sourceData) const =0;
  /**
   * return source and sink of a converter
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if gateway
   * was not found
   */
  virtual am_Error_e getConverterInfoDB(const am_converterID_t converterID, am_Converter_s& converterData) const =0;
  /**
   * return source and sink of a gateway
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if gateway
   * was not found
   */
  virtual am_Error_e getGatewayInfoDB(const am_gatewayID_t gatewayID, am_Gateway_s& gatewayData) const =0;
  /**
   * returns sources and the sink of a crossfader
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if
   * crossfader was not found
   */
  virtual am_Error_e getCrossfaderInfoDB(const am_crossfaderID_t crossfaderID, am_Crossfader_s& crossfaderData) const =0;
  /**
   * returns sources and the sink of a crossfader
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if
   * crossfader was not found
   */
  virtual am_Error_e getMainConnectionInfoDB(const am_mainConnectionID_t mainConnectionID, am_MainConnection_s& mainConnectionData) const =0;
  /**
   * returns all sinks of a domain
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if domain
   * was not found
   */
  virtual am_Error_e getListSinksOfDomain(const am_domainID_t domainID, std::vector<am_sinkID_t>& listSinkID) const =0;
  /**
   * returns all source of a domain
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if domain
   * was not found
   */
  virtual am_Error_e getListSourcesOfDomain(const am_domainID_t domainID, std::vector<am_sourceID_t>& listSourceID) const =0;
  /**
   * returns all crossfaders of a domain
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if domain
   * was not found
   */
  virtual am_Error_e getListCrossfadersOfDomain(const am_domainID_t domainID, std::vector<am_crossfaderID_t>& listCrossfadersID) const =0;
  /**
   * returns all converters of a domain
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if domain
   * was not found
   */
  virtual am_Error_e getListConvertersOfDomain(const am_domainID_t domainID, std::vector<am_converterID_t>& listConverterID) const =0;
  /**
   * returns all gateways of a domain
   * @return E_OK on success, E_DATABASE_ERROR on error, E_NON_EXISTENT if domain
   * was not found
   */
  virtual am_Error_e getListGatewaysOfDomain(const am_domainID_t domainID, std::vector<am_gatewayID_t>& listGatewaysID) const =0;
  /**
   * returns a complete list of all MainConnections
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListMainConnections(std::vector<am_MainConnection_s>& listMainConnections) const =0;
  /**
   * returns a complete list of all domains
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListDomains(std::vector<am_Domain_s>& listDomains) const =0;
  /**
   * returns a complete list of all Connections
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListConnections(std::vector<am_Connection_s>& listConnections) const =0;
  /**
   * returns a list of all sinks
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListSinks(std::vector<am_Sink_s>& listSinks) const =0;
  /**
   * returns a list of all sources
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListSources(std::vector<am_Source_s>& listSources) const =0;
  /**
   * returns a list of all source classes
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListSourceClasses(std::vector<am_SourceClass_s>& listSourceClasses) const =0;
  /**
   * returns a list of all handles
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListHandles(std::vector<am_Handle_s>& listHandles) const =0;
  /**
   * returns a list of all crossfaders
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListCrossfaders(std::vector<am_Crossfader_s>& listCrossfaders) const =0;
  /**
   * returns a list of  converters
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListConverters(std::vector<am_Converter_s>& listConverters) const =0;
  /**
   * returns a list of  gateways
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListGateways(std::vector<am_Gateway_s>& listGateways) const =0;
  /**
   * returns a list of all sink classes
   * @return E_OK on success, E_DATABASE_ERROR on error
   */
  virtual am_Error_e getListSinkClasses(std::vector<am_SinkClass_s>& listSinkClasses) const =0;
  /**
   * returns the list of SystemProperties
   */
  virtual am_Error_e getListSystemProperties(std::vector<am_SystemProperty_s>& listSystemProperties) const =0;
  /**
   * sets the command interface to ready. Will send setCommandReady to each of the
   * plugins. The corresponding answer is confirmCommandReady.
   */
  virtual void setCommandReady() =0;
  /**
   * sets the command interface into the rundown state. Will send setCommandRundown
   * to each of the plugins. The corresponding answer is confirmCommandRundown.
   */
  virtual void setCommandRundown() =0;
  /**
   * sets the routinginterface to  ready. Will send the command  setRoutingReady to
   * each of the plugins. The related answer is confirmRoutingReady.
   */
  virtual void setRoutingReady() =0;
  /**
   * sets the routinginterface to the rundown state. Will send the command
   * setRoutingRundown to each of the plugins. The related answer is
   * confirmRoutingRundown.
   */
  virtual void setRoutingRundown() =0;
  /**
   * acknowledges the setControllerReady call.
   */
  virtual void confirmControllerReady(const am_Error_e error) =0;
  /**
   * Acknowledges the setControllerRundown call.
   */
  virtual void confirmControllerRundown(const am_Error_e error) =0;
  /**
   * This function returns the pointer to the socketHandler. This can be used to
   * integrate socket-based activites like communication with the mainloop of the
   * AudioManager.
   * returns E_OK if pointer is valid, E_UNKNOWN in case AudioManager was compiled
   * without socketHandler support,
   */
  virtual am_Error_e getSocketHandler(CAmSocketHandler*& socketHandler) =0;
  /**
   * Change the data of the source.
   */
  virtual am_Error_e changeSourceDB(const am_sourceID_t sourceID, const am_sourceClass_t sourceClassID, const std::vector<am_SoundProperty_s>& listSoundProperties, const std::vector<am_CustomConnectionFormat_t>& listConnectionFormats, const std::vector<am_MainSoundProperty_s>& listMainSoundProperties) =0;
  /**
   * Change the data of the sink.
   */
  virtual am_Error_e changeSinkDB(const am_sinkID_t sinkID, const am_sinkClass_t sinkClassID, const std::vector<am_SoundProperty_s>& listSoundProperties, const std::vector<am_CustomConnectionFormat_t>& listConnectionFormats, const std::vector<am_MainSoundProperty_s>& listMainSoundProperties) =0;
  /**
   * changes converter Data
   */
  virtual am_Error_e changeConverterDB(const am_converterID_t converterID, const std::vector<am_CustomConnectionFormat_t>& listSourceConnectionFormats, const std::vector<am_CustomConnectionFormat_t>& listSinkConnectionFormats, const std::vector<bool>& convertionMatrix) =0;
  /**
   * changes Gateway Data
   */
  virtual am_Error_e changeGatewayDB(const am_gatewayID_t gatewayID, const std::vector<am_CustomConnectionFormat_t>& listSourceConnectionFormats, const std::vector<am_CustomConnectionFormat_t>& listSinkConnectionFormats, const std::vector<bool>& convertionMatrix) =0;
  /**
   * with this function, setting of multiple volumes at a time is done. The behavior
   * of the volume set is depended on the given ramp and time information.
   * This function is not only used to ramp volume, but also to mute and direct set
   * the level. Exact behavior is depended on the selected mute ramps.
   * @return E_OK on success, E_NO_CHANGE if the volume is already on the desired
   * value, E_OUT_OF_RANGE is the volume is out of range, E_UNKNOWN on every other
   * error.
   */
  virtual am_Error_e setVolumes(am_Handle_s& handle, const std::vector<am_Volumes_s>& listVolumes) =0;
  /**
   * set a sink notification configuration
   */
  virtual am_Error_e setSinkNotificationConfiguration(am_Handle_s& handle, const am_sinkID_t sinkID, const am_NotificationConfiguration_s& notificationConfiguration) =0;
  /**
   * set a source notification configuration
   */
  virtual am_Error_e setSourceNotificationConfiguration(am_Handle_s& handle, const am_sourceID_t sourceID, const am_NotificationConfiguration_s& notificationConfiguration) =0;
  /**
   * Sends out the main notificiation of a sink
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual void sendMainSinkNotificationPayload(const am_sinkID_t sinkID, const am_NotificationPayload_s& notificationPayload) =0;
  /**
   * Sends out the main notificiation of a source
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual void sendMainSourceNotificationPayload(const am_sourceID_t sourceID, const am_NotificationPayload_s& notificationPayload) =0;
  /**
   * change the mainNotificationConfiguration of a sink
   * @return E_OK when successful, E_DATABASE on error
   */
  virtual am_Error_e changeMainSinkNotificationConfigurationDB(const am_sinkID_t sinkID, const am_NotificationConfiguration_s& mainNotificationConfiguration) =0;
  /**
   * change the mainNotificationConfiguration of a source
   * @return E_OK when successful, E_DATABASE on error
   */
  virtual am_Error_e changeMainSourceNotificationConfigurationDB(const am_sourceID_t sourceID, const am_NotificationConfiguration_s& mainNotificationConfiguration) =0;
  /**
   * This function retrieves a list of all sink mainsoundproperties with its values
   * @return E_OK when successful, E_DATABASE on error
   */
  virtual am_Error_e getListMainSinkSoundProperties(const am_sinkID_t sinkID, std::vector<am_MainSoundProperty_s>& listSoundproperties) const =0;
  /**
   * This function retrieves a list of all source mainsoundproperties with its
   * values
   * @return E_OK when successful, E_DATABASE on error
   */
  virtual am_Error_e getListMainSourceSoundProperties(const am_sourceID_t sourceID, std::vector<am_MainSoundProperty_s>& listSoundproperties) const =0;
  /**
   * This function retrieves a list of all sink soundproperties with its values
   * @return E_OK when successful, E_DATABASE on error
   */
  virtual am_Error_e getListSinkSoundProperties(const am_sinkID_t sinkID, std::vector<am_SoundProperty_s>& listSoundproperties) const =0;
  /**
   * This function retrieves a list of all sink soundproperties with its values
   * @return E_OK when successful, E_DATABASE on error
   */
  virtual am_Error_e getListSourceSoundProperties(const am_sourceID_t sourceID, std::vector<am_SoundProperty_s>& listSoundproperties) const =0;
  /**
   * This function retrieves the value of a sink Mainsoundproperty.
   * @return E_OK when successful, E_DATABASE on error
   */
  virtual am_Error_e getMainSinkSoundPropertyValue(const am_sinkID_t sinkID, const am_CustomMainSoundPropertyType_t propertyType, int16_t& value) const =0;
  /**
   * This function retrieves the value of a sink soundproperty.
   * @return E_OK when successful, E_DATABASE on error
   */
  virtual am_Error_e getSinkSoundPropertyValue(const am_sinkID_t sinkID, const am_CustomSoundPropertyType_t propertyType, int16_t& value) const =0;
  /**
   * This function retrieves the value of a source Mainsoundproperty.
   * @return E_OK when successful, E_DATABASE on error
   */
  virtual am_Error_e getMainSourceSoundPropertyValue(const am_sourceID_t sourceID, const am_CustomMainSoundPropertyType_t propertyType, int16_t& value) const =0;
  /**
   * This function retrieves the value of a source soundproperty.
   * @return E_OK when successful, E_DATABASE on error
   */
  virtual am_Error_e getSourceSoundPropertyValue(const am_sourceID_t sourceID, const am_CustomSoundPropertyType_t propertyType, int16_t& value) const =0;

};

/**
 * This interface is presented by the AudioManager controller.
 * All the hooks represent system events that need to be handled. The callback
 * functions are used to handle for example answers to function calls on the
 * AudioManagerCoreInterface.
 * There are two rules that have to be kept in mind when implementing against this
 * interface:\n
 * \warning
 * 1. CALLS TO THIS INTERFACE ARE NOT THREAD SAFE !!!! \n
 * 2. YOU MAY NOT CALL THE CALLING INTERFACE DURING AN SYNCHRONOUS OR ASYNCHRONOUS
 * CALL THAT EXPECTS A RETURN VALUE.\n
 * \details
 * Violation these rules may lead to unexpected behavior! Nevertheless you can
 * implement thread safe by using the deferred-call pattern described on the wiki
 * which also helps to implement calls that are forbidden.\n
 * For more information, please check CAmSerializer
 */
class IAmControlSend
{

public:
  IAmControlSend() {

  }

  virtual ~IAmControlSend() {

  }

  /**
   * This function returns the version of the interface
   * returns E_OK, E_UNKOWN if version is unknown.
   */
  virtual void getInterfaceVersion(std::string& version) const =0;
  /**
   * Starts up the controller.
   */
  virtual am_Error_e startupController(IAmControlReceive* controlreceiveinterface) =0;
  /**
   * this message is used tell the controller that it should get ready. This message
   * must be acknowledged via confirmControllerReady.
   */
  virtual void setControllerReady() =0;
  /**
   * This message tells the controller that he should prepare everything for the
   * power to be switched off. This message must be acknowledged via
   * confirmControllerRundown.
   * The method will give the signal as integer that was responsible for calling the
   * setControllerRundown.
   * This function is called from the signal handler, either direct (when the
   * program is killed) or from within the mainloop (if the program is terminated).
   */
  virtual void setControllerRundown(const int16_t signal) =0;
  /**
   * is called when a connection request comes in via the command interface
   * @return E_OK on success, E_NOT_POSSIBLE on error, E_ALREADY_EXISTENT if already
   * exists
   */
  virtual am_Error_e hookUserConnectionRequest(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID) =0;
  /**
   * is called when a disconnection request comes in via the command interface
   * @return E_OK on success, E_NOT_POSSIBLE on error, E_NON_EXISTENT if connection
   * does not exists
   */
  virtual am_Error_e hookUserDisconnectionRequest(const am_mainConnectionID_t connectionID) =0;
  /**
   * sets a user MainSinkSoundProperty
   * @return E_OK on success, E_OUT_OF_RANGE if out of range, E_UNKNOWN on error
   */
  virtual am_Error_e hookUserSetMainSinkSoundProperty(const am_sinkID_t sinkID, const am_MainSoundProperty_s& soundProperty) =0;
  /**
   * sets a user MainSourceSoundProperty
   * @return E_OK on success, E_OUT_OF_RANGE if out of range, E_UNKNOWN on error
   */
  virtual am_Error_e hookUserSetMainSourceSoundProperty(const am_sourceID_t sourceID, const am_MainSoundProperty_s& soundProperty) =0;
  /**
   * sets a user SystemProperty
   * @return E_OK on success, E_OUT_OF_RANGE if out of range, E_UNKNOWN on error
   */
  virtual am_Error_e hookUserSetSystemProperty(const am_SystemProperty_s& property) =0;
  /**
   * sets a user volume
   * @return E_OK on success, E_OUT_OF_RANGE if out of range, E_UNKNOWN on error
   */
  virtual am_Error_e hookUserVolumeChange(const am_sinkID_t SinkID, const am_mainVolume_t newVolume) =0;
  /**
   * sets a user volume as increment
   * @return E_OK on success, E_OUT_OF_RANGE if out of range, E_UNKNOWN on error
   */
  virtual am_Error_e hookUserVolumeStep(const am_sinkID_t SinkID, const int16_t increment) =0;
  /**
   * sets the mute state of a sink
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual am_Error_e hookUserSetSinkMuteState(const am_sinkID_t sinkID, const am_MuteState_e muteState) =0;
  /**
   * is called when a routing adaptor registers its domain
   * @return E_OK on success, E_UNKNOWN on error, E_ALREADY_EXISTENT if already
   * exists
   */
  virtual am_Error_e hookSystemRegisterDomain(const am_Domain_s& domainData, am_domainID_t& domainID) =0;
  /**
   * is called when a routing adaptor wants to derigister a domain
   * @return E_OK on success, E_UNKNOWN on error, E_NON_EXISTENT if not found
   */
  virtual am_Error_e hookSystemDeregisterDomain(const am_domainID_t domainID) =0;
  /**
   * is called when a domain registered all the elements
   */
  virtual void hookSystemDomainRegistrationComplete(const am_domainID_t domainID) =0;
  /**
   * is called when a routing adaptor registers a sink
   * @return E_OK on success, E_UNKNOWN on error, E_ALREADY_EXISTENT if already
   * exists
   */
  virtual am_Error_e hookSystemRegisterSink(const am_Sink_s& sinkData, am_sinkID_t& sinkID) =0;
  /**
   * is called when a routing adaptor deregisters a sink
   * @return E_OK on success, E_UNKNOWN on error, E_NON_EXISTENT if not found
   */
  virtual am_Error_e hookSystemDeregisterSink(const am_sinkID_t sinkID) =0;
  /**
   * is called when a routing adaptor registers a source
   * @return E_OK on success, E_UNKNOWN on error, E_ALREADY_EXISTENT if already
   * exists
   */
  virtual am_Error_e hookSystemRegisterSource(const am_Source_s& sourceData, am_sourceID_t& sourceID) =0;
  /**
   * is called when a routing adaptor deregisters a source
   * @return E_OK on success, E_UNKNOWN on error, E_NON_EXISTENT if not found
   */
  virtual am_Error_e hookSystemDeregisterSource(const am_sourceID_t sourceID) =0;
  /**
   * is called when a routing adaptor registers a converter
   * @return E_OK on success, E_UNKNOWN on error, E_ALREADY_EXISTENT if already
   * exists
   */
  virtual am_Error_e hookSystemRegisterConverter(const am_Converter_s& converterData, am_converterID_t& converterID) =0;
  /**
   * is called when a routing adaptor registers a gateway
   * @return E_OK on success, E_UNKNOWN on error, E_ALREADY_EXISTENT if already
   * exists
   */
  virtual am_Error_e hookSystemRegisterGateway(const am_Gateway_s& gatewayData, am_gatewayID_t& gatewayID) =0;
  /**
   * is called when a routing adaptor deregisters a converter
   * @return E_OK on success, E_UNKNOWN on error, E_NON_EXISTENT if not found
   */
  virtual am_Error_e hookSystemDeregisterConverter(const am_converterID_t converterID) =0;
  /**
   * is called when a routing adaptor deregisters a gateway
   * @return E_OK on success, E_UNKNOWN on error, E_NON_EXISTENT if not found
   */
  virtual am_Error_e hookSystemDeregisterGateway(const am_gatewayID_t gatewayID) =0;
  /**
   * is called when a routing adaptor registers a crossfader
   * @return E_OK on success, E_UNKNOWN on error, E_ALREADY_EXISTENT if already
   * exists
   */
  virtual am_Error_e hookSystemRegisterCrossfader(const am_Crossfader_s& crossfaderData, am_crossfaderID_t& crossfaderID) =0;
  /**
   * is called when a routing adaptor deregisters a crossfader
   * @return E_OK on success, E_UNKNOWN on error, E_NON_EXISTENT if not found
   */
  virtual am_Error_e hookSystemDeregisterCrossfader(const am_crossfaderID_t crossfaderID) =0;
  /**
   * volumeticks. therse are used to indicate volumechanges during a ramp
   */
  virtual void hookSystemSinkVolumeTick(const am_Handle_s handle, const am_sinkID_t sinkID, const am_volume_t volume) =0;
  /**
   * volumeticks. therse are used to indicate volumechanges during a ramp
   */
  virtual void hookSystemSourceVolumeTick(const am_Handle_s handle, const am_sourceID_t sourceID, const am_volume_t volume) =0;
  /**
   * is called when an low level interrupt changed its state
   */
  virtual void hookSystemInterruptStateChange(const am_sourceID_t sourceID, const am_InterruptState_e interruptState) =0;
  /**
   * id called when a sink changed its availability
   */
  virtual void hookSystemSinkAvailablityStateChange(const am_sinkID_t sinkID, const am_Availability_s& availability) =0;
  /**
   * id called when a source changed its availability
   */
  virtual void hookSystemSourceAvailablityStateChange(const am_sourceID_t sourceID, const am_Availability_s& availability) =0;
  /**
   * id called when domainstate was changed
   */
  virtual void hookSystemDomainStateChange(const am_domainID_t domainID, const am_DomainState_e state) =0;
  /**
   * when early data was received
   */
  virtual void hookSystemReceiveEarlyData(const std::vector<am_EarlyData_s>& data) =0;
  /**
   * this hook provides information about speed changes.
   * The quantization and sampling rate of the speed can be adjusted at compile time
   * of the AudioManagerDaemon.
   */
  virtual void hookSystemSpeedChange(const am_speed_t speed) =0;
  /**
   * this hook is fired whenever the timing information of a mainconnection has
   * changed.
   */
  virtual void hookSystemTimingInformationChanged(const am_mainConnectionID_t mainConnectionID, const am_timeSync_t time) =0;
  /**
   * ack for connect
   */
  virtual void cbAckConnect(const am_Handle_s handle, const am_Error_e errorID) =0;
  /**
   * ack for disconnect
   */
  virtual void cbAckDisconnect(const am_Handle_s handle, const am_Error_e errorID) =0;
  /**
   * ack for crossfading
   */
  virtual void cbAckCrossFade(const am_Handle_s handle, const am_HotSink_e hostsink, const am_Error_e error) =0;
  /**
   * ack for sink volume changes
   */
  virtual void cbAckSetSinkVolumeChange(const am_Handle_s handle, const am_volume_t volume, const am_Error_e error) =0;
  /**
   * ack for source volume changes
   */
  virtual void cbAckSetSourceVolumeChange(const am_Handle_s handle, const am_volume_t voulme, const am_Error_e error) =0;
  /**
   * ack for setting of source states
   */
  virtual void cbAckSetSourceState(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * ack for setting of sourcesoundproperties
   */
  virtual void cbAckSetSourceSoundProperties(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * ack for setting of sourcesoundproperties
   */
  virtual void cbAckSetSourceSoundProperty(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * ack for setting of sinksoundproperties
   */
  virtual void cbAckSetSinkSoundProperties(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * ack for setting of sinksoundproperties
   */
  virtual void cbAckSetSinkSoundProperty(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * This function is used by the routing algorithm to retrieve a priorized list of
   * connectionFormats from the Controller.
   * @return E_OK in case of successfull priorisation.
   */
  virtual am_Error_e getConnectionFormatChoice(const am_sourceID_t sourceID, const am_sinkID_t sinkID, const am_Route_s listRoute, const std::vector<am_CustomConnectionFormat_t> listPossibleConnectionFormats, std::vector<am_CustomConnectionFormat_t>& listPrioConnectionFormats) =0;
  /**
   * confirms the setCommandReady call
   */
  virtual void confirmCommandReady(const am_Error_e error) =0;
  /**
   * confirms the setRoutingReady call
   */
  virtual void confirmRoutingReady(const am_Error_e error) =0;
  /**
   * confirms the setCommandRundown call
   */
  virtual void confirmCommandRundown(const am_Error_e error) =0;
  /**
   * confirms the setRoutingRundown command
   */
  virtual void confirmRoutingRundown(const am_Error_e error) =0;
  /**
   * update form the SinkData
   */
  virtual am_Error_e hookSystemUpdateSink(const am_sinkID_t sinkID, const am_sinkClass_t sinkClassID, const std::vector<am_SoundProperty_s>& listSoundProperties, const std::vector<am_CustomConnectionFormat_t>& listConnectionFormats, const std::vector<am_MainSoundProperty_s>& listMainSoundProperties) =0;
  /**
   * update from the source Data
   */
  virtual am_Error_e hookSystemUpdateSource(const am_sourceID_t sourceID, const am_sourceClass_t sourceClassID, const std::vector<am_SoundProperty_s>& listSoundProperties, const std::vector<am_CustomConnectionFormat_t>& listConnectionFormats, const std::vector<am_MainSoundProperty_s>& listMainSoundProperties) =0;
  /**
   * updates the Converter Data
   */
  virtual am_Error_e hookSystemUpdateConverter(const am_converterID_t converterID, const std::vector<am_CustomConnectionFormat_t>& listSourceConnectionFormats, const std::vector<am_CustomConnectionFormat_t>& listSinkConnectionFormats, const std::vector<bool>& convertionMatrix) =0;
  /**
   * updates the Gateway Data
   */
  virtual am_Error_e hookSystemUpdateGateway(const am_gatewayID_t gatewayID, const std::vector<am_CustomConnectionFormat_t>& listSourceConnectionFormats, const std::vector<am_CustomConnectionFormat_t>& listSinkConnectionFormats, const std::vector<bool>& convertionMatrix) =0;
  /**
   * ack for mulitple volume changes
   */
  virtual void cbAckSetVolumes(const am_Handle_s handle, const std::vector<am_Volumes_s>& listVolumes, const am_Error_e error) =0;
  /**
   * The acknowledge of the sink notification configuration
   */
  virtual void cbAckSetSinkNotificationConfiguration(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * The acknowledge of the source notification configuration
   */
  virtual void cbAckSetSourceNotificationConfiguration(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * new sinkNotification data is there!
   */
  virtual void hookSinkNotificationDataChanged(const am_sinkID_t sinkID, const am_NotificationPayload_s& payload) =0;
  /**
   * new sourceNotification data is there!
   */
  virtual void hookSourceNotificationDataChanged(const am_sourceID_t sourceID, const am_NotificationPayload_s& payload) =0;
  /**
   * sets a user MainSinkNotificationConfiguration
   * @return E_OK on success, E_OUT_OF_RANGE if out of range, E_UNKNOWN on error
   */
  virtual am_Error_e hookUserSetMainSinkNotificationConfiguration(const am_sinkID_t sinkID, const am_NotificationConfiguration_s& notificationConfiguration) =0;
  /**
   * sets a user MainSourceNotificationConfiguration
   * @return E_OK on success, E_OUT_OF_RANGE if out of range, E_UNKNOWN on error
   */
  virtual am_Error_e hookUserSetMainSourceNotificationConfiguration(const am_sourceID_t sourceID, const am_NotificationConfiguration_s& notificationConfiguration) =0;
  /**
   * This hook is fired whenever the timing information of a connection has changed.
   */
  virtual void hookSystemSingleTimingInformationChanged(const am_connectionID_t connectionID, const am_timeSync_t time) =0;

};
}
#endif // !defined(EA_69597D9E_B0A3_4c6d_BBB6_E7F436B8B799__INCLUDED_)
